const MicLineSelectMap = new Map([
    ["mic", "Mic In"],
    ["line", "Line In"]
]);

const AudInCodec2EncodeMap = new Map([
    ["aac_48k", "AAC"],
    ["aac_44.1k", "AAC"],
    ["aac_16k", "AAC"],
    ["g711_16k", "G.711"],
    ["g711_8k", "G.711"]
]);

const AudInCodec2SampleRateMap = new Map([
    ["aac_48k", "48 KHz"],
    ["aac_44.1k", "44.1 KHz"],
    ["aac_16k", "16 KHz"],
    ["g711_16k", "16 KHz"],
    ["g711_8k", "8 KHz"]
]);

function updateEncodeType() {
    var encodeType = $("#encodeTypeSelect").val();
    $("#encodeSampleRateSelect option").remove();
    if (encodeType == "AAC") {
        $("#encodeSampleRateSelect").append($("<option></option>").text("48 KHz"));
        $("#encodeSampleRateSelect").append($("<option></option>").text("44.1 KHz"));
        $("#encodeSampleRateSelect").append($("<option></option>").text("16 KHz"));
    } else if (encodeType == "G.711") {
        $("#encodeSampleRateSelect").append($("<option></option>").text("16 KHz"));
        $("#encodeSampleRateSelect").append($("<option></option>").text("8 KHz"));
    }
}

function updateAudioEnable() {
    if (document.getElementById("audioEnableCheckboxInput").checked == true) {
        document.getElementById("audioInTypeSelect").disabled = false;
        document.getElementById("audioVolumeRangeInput").disabled = false;
        document.getElementById("audioVolumeInput").disabled = false;
        if (cameraSettings.NdiEnable == "on" || cameraSettings.OutputSource == "hdmi+uvc") {
            document.getElementById("encodeTypeSelect").disabled = true;
            document.getElementById("encodeSampleRateSelect").disabled = true;
            document.getElementById("audioDelayCheckboxInput").disabled = true;
            document.getElementById("delayTimeRangeInput").disabled = true;
            document.getElementById("delayTimeInput").disabled = true;
        } else {
            document.getElementById("encodeTypeSelect").disabled = false;
            document.getElementById("encodeSampleRateSelect").disabled = false;
            document.getElementById("audioDelayCheckboxInput").disabled = false;
            updateAudioDelayEnable();
        }
    } else {
        document.getElementById("audioInTypeSelect").disabled = true;
        document.getElementById("encodeTypeSelect").disabled = true;
        document.getElementById("encodeSampleRateSelect").disabled = true;
        document.getElementById("audioVolumeRangeInput").disabled = true;
        document.getElementById("audioVolumeInput").disabled = true;
        document.getElementById("audioDelayCheckboxInput").disabled = true;
        document.getElementById("delayTimeRangeInput").disabled = true;
        document.getElementById("delayTimeInput").disabled = true;
    }
}

function updateAudioDelayEnable() {
    if (document.getElementById("audioDelayCheckboxInput").checked == true) {
        document.getElementById("delayTimeRangeInput").disabled = false;
        document.getElementById("delayTimeInput").disabled = false;
    } else {
        document.getElementById("delayTimeRangeInput").disabled = true;
        document.getElementById("delayTimeInput").disabled = true;
    }
}

function convertParamWebtoCGI(param) {
    param.AudioIn = ($('#audioEnableCheckboxInput').is(':checked') == true) ? "on" : "off";
    param.MicLineSelect = ($('#audioInTypeSelect').val() == "Mic In") ? "mic" : "line";
    param.AudioInVolume = $('#audioVolumeRangeInput').val();
    param.AudioDelay = ($('#audioDelayCheckboxInput').is(':checked') == true) ? "on" : "off";
    param.AudioDelayTime = $('#delayTimeRangeInput').val();
    if ($('#encodeTypeSelect').val() == "AAC") {
        if ($('#encodeSampleRateSelect').val() == "48 KHz")
            param.AudInCodec = "aac_48k";
        else if ($('#encodeSampleRateSelect').val() == "44.1 KHz")
            param.AudInCodec = "aac_44.1k";
        else if ($('#encodeSampleRateSelect').val() == "16 KHz")
            param.AudInCodec = "aac_16k";
    } else if ($('#encodeTypeSelect').val() == "G.711") {
        if ($('#encodeSampleRateSelect').val() == "16 KHz")
            param.AudInCodec = "g711_16k";
        else if ($('#encodeSampleRateSelect').val() == "8 KHz")
            param.AudInCodec = "g711_8k";
    }
}

function saveAudioSettings() {
    var audioParam = {};
    addTime = 0;
    urlToSend = "/command/camera.cgi?";

    convertParamWebtoCGI(audioParam);
    AddParameter("AudioIn", audioParam.AudioIn);
    if (audioParam.AudioIn == "on") {
        AddParameter("MicLineSelect", audioParam.MicLineSelect);
        AddParameter("AudioInVolume", audioParam.AudioInVolume);
        if (cameraSettings.NdiEnable != "on" && cameraSettings.OutputSource != "hdmi+uvc") {
            AddParameter("AudInCodec", audioParam.AudInCodec);
            AddParameter("AudioDelay", audioParam.AudioDelay);
            if (audioParam.AudioDelay == "on") {
                AddParameter("AudioDelayTime", audioParam.AudioDelayTime);
            }
        }
    }

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send Audio Setting Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            console.log("Audio settings saved to " + cameraSettings.CameraName);
            reloadAudio();
            UnblockUIforPage();
        }
    });
}

function reloadAudio() {
    openAudio();
}

function openAudio() {
    $("#DivMainPage").load("./page/audio.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;

        $.ajax({
            url: "/command/inquiry.cgi?inqjs=camera&inqjs=network&inqjs=ndi",
            type: "GET",
            error: function (xhr) {
                console.log("Get system info fail");
            },
            success: function (response) {
                var pcDateNow = {};
                const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
                var result = [];
                while (result = regEx.exec(response)) {
                    cameraSettings[result[1]] = result[2];
                }

                // update value
                $("#audioEnableCheckboxInput").prop("checked", OnOff2Bool(cameraSettings.AudioIn));
                $("#audioInTypeSelect").val(MicLineSelectMap.get(cameraSettings.MicLineSelect));
                $("#encodeTypeSelect").val(AudInCodec2EncodeMap.get(cameraSettings.AudInCodec));
                updateEncodeType();
                $("#encodeSampleRateSelect").val(AudInCodec2SampleRateMap.get(cameraSettings.AudInCodec));
                $("#audioVolumeRangeInput").val(cameraSettings.AudioInVolume);
                $("#audioVolumeInput").val(cameraSettings.AudioInVolume);
                $("#audioDelayCheckboxInput").prop("checked", OnOff2Bool(cameraSettings.AudioDelay));
                $("#delayTimeRangeInput").val(cameraSettings.AudioDelayTime);
                $("#delayTimeInput").val(cameraSettings.AudioDelayTime);

                // update disable attribute
                updateAudioEnable();

                // activate elements
                $("#audioEnableCheckboxInput").change(function () {
                    updateAudioEnable();
                });

                $("#encodeTypeSelect").change(function () {
                    updateEncodeType();
                });

                $("#audioVolumeInput").change(function () {
                    var value = $("#audioVolumeInput").val();
                    if (value < 0)
                        value = 0;
                    else if (value > 10)
                        value = 10;
                    $("#audioVolumeRangeInput").val(value);
                    $("#audioVolumeInput").val(value);
                });

                $("#audioDelayCheckboxInput").change(function () {
                    updateAudioDelayEnable();
                });

                $("#delayTimeInput").change(function () {
                    var value = $("#delayTimeInput").val();
                    if (value < 1)
                        value = 1;
                    else if (value > 500)
                        value = 500;
                    $("#delayTimeRangeInput").val(value);
                    $("#delayTimeInput").val(value);
                });

                $("#applyButton").on('click', function () {
                    if (document.getElementById("audioEnableCheckboxInput").checked != OnOff2Bool(cameraSettings.AudioIn) ||
                        $("#encodeTypeSelect").val() != AudInCodec2EncodeMap.get(cameraSettings.AudInCodec) ||
                        $("#encodeSampleRateSelect").val() != AudInCodec2SampleRateMap.get(cameraSettings.AudInCodec)) {
                        showConfirmationModal("Message", "The camera will restart, are you sure?", saveAudioSettings, reloadAudio, true);
                    } else {
                        saveAudioSettings();
                    }
                });
                $("#cancelButton").on('click', reloadAudio);
            }
        });
    });
}
